1 REM PAYROLL2  
10 CLS:PRINT  TAB(15);"PAYROLL PROGRAM":PRINT   
20 PRINT "THIS PROGRAM IS A BRIEF IN-MEMORY PAYROLL SYSTEM. ESSENTIALLY  
25 PRINT "IT IS A PROGRAM WHICH COMPUTES FEDERAL AND FICA WITHHOLDING  
30 PRINT "AND STORES PAY RECORDS IN A FORM WHICH PERMITS EASY ACCESS  
35 PRINT "TO THOSE INTERESTED IN 941 OR W-2 FORMS. THERE IS,AT PRESENT,  
40 PRINT "NO PROVISION FOR STATE OR LOCAL WITHHOLDING BUT THIS CAN BE  
45 PRINT "HANDLED VIA THE 'OTHER DEDUCTIONS' CATEGORY. THE DIMENSIONING  
47 PRINT "LIMITS THE PAYROLL MASTER FILE TO 25 EMPLOYEES, THOUGH THIS  
49 PRINT "MAY BE INCREASED IF MUCH MAIN MEMORY IS AVAILABLE.  
50 PRINT"REMEMBER THAT THE MASTER MUST BE RECALLED FROM STORAGE BEFORE  
52 PRINT "OPERATIONS ARE PERFORMED AND RESTORED AFTER THE OPERATIONS.  
53 PRINT :PRINT "DELETE LINES 1-58 TO RUN ON 16K SYSTEM"  
56 PRINT :INPUT "PRESS ENTER TO BEGIN";Z9$  
58 CLEAR  2000  
59 NC=25:DIM  A(NC,15),A$(NC,5)  
65 DIM F$(20):REM FORMATTING  
67 DIM  P(2,9),B(2,9),V(11)  
70 GOSUB  9000  
75 GOSUB  14000  
80 FOR  I=1  TO  NC:A$(I,1)="9999":NEXT   
100 CLS:INPUT "ARE DISK DRIVES ATTACHED(Y/N)";ZD$  
110 IF  ZD$<>"Y"  AND  ZD$<>"N"  THEN  GOSUB  10000:GOTO  100  
500 CLS:PRINT "       MAIN MENU":PRINT   
505 PRINT " 0.QUIT
510 PRINT " 1.MASTER FILE MAINTENANCE  
520 PRINT " 2.READ FILE IN FROM TAPE  
530 PRINT " 3.WRITE FILE OUT ONTO TAPE  
540 PRINT " 4.READ FILE IN FROM DISK  
550 PRINT " 5.WRITE FILE OUT ONTO DISK  
560 PRINT " 6.COMPUTE PAYROLL  
570 PRINT " 7.POST PAYROLL TO YTD TOTALS  
580 PRINT " 8.REPORT GENERATOR  
590 PRINT " 9.END OF PERIOD FILE MAINTENANCE  
595 ON  ERROR  GOTO  15000  
600 INPUT "ENTER YOUR CHOICE";Z9  
605 IF Z9 = 0 THEN END
610 ON  Z9 GOSUB  3100,2000,2100,2200,2300,7800,7000,5000,7300  
620 GOTO  500  
1500 CLOSE:RESUME 500  
2000 REM READ IN FILE FROM TAPE  
2010 CLS:PRINT "PUT DATA TAPE IN TAPE DRIVE":GOSUB  10100  
2015 ' IF  ZD$="Y"  THEN  CMD"T"  
2020 INPUT #-1,NC  
2035 FOR  I=1  TO  NC:GOSUB  2500:NEXT  I  
2040 RETURN   
2100 REM WRITE OUT FILE ONTO TAPE  
2105 CLS  
2110 PRINT "PUT DATA TAPE IN TAPE DRIVE":GOSUB  10100  
2115 ' IF  ZD$="Y"  THEN  CMD"T"  
2130 WRITE #-1,NC  
2145 FOR  I=1  TO  NC:GOSUB  2600:NEXT  I  
2150 RETURN   
2200 REM READ IN FILE FROM DISK  
2210 CLS:PRINT "PUT DATA DISK IN DISK DRIVE":GOSUB  10100  
2220 ON  ERROR  GOTO  2290  
2225 INPUT "ENTER NAME OF DATA FILE TO BE READ ";ZN$  
2230 OPEN "I",1,ZN$  
2240 INPUT # 1,NC  
2255 FOR  I=1  TO  NC:GOSUB  2550:NEXT  I  
2260 CLOSE # 1  
2270 RETURN   
2290 PRINT  "FILE DOES NOT EXIST":GOSUB  10100:RESUME 2225  
2300 REM WRITE FILE OUT TO DISK  
2305 CLS  
2310 PRINT :PRINT "PUT DATA DISK IN DISK DRIVE":GOSUB  10100  
2315 PRINT "PRESENT FILE NAME IS ";ZN$;:INPUT " NEW NAME";ZN$  
2320 OPEN "O",1,ZN$  
2330 WRITE # 1,NC  
2345 FOR  I=1  TO  NC:GOSUB  2650:NEXT  I  
2370 CLOSE # 1  
2380 RETURN   
2500 REM INPUT 1 EMPLOYEE FROM TAPE  
2510 FOR  JI=0 TO 15:INPUT #-1,A(I,JI):NEXT :FOR  JI=1 TO 5:INPUT #-1,A$(I,JI):Z8$=A$(I,JI):GOSUB  11000:A$(I,JI)=Z8$:NEXT  JI  
2520 RETURN   
2550 REM INPUT 1 EMPLOYEE FROM DISKETTE  
2560 FOR  JI=0 TO 15:INPUT # 1,A(I,JI):NEXT :FOR  JI=1 TO 5:INPUT # 1,A$(I,JI):Z8$=A$(I,JI):GOSUB  11000:A$(I,JI)=Z8$:NEXT  JI  
2570 RETURN   
2600 REM OUTPUT 1 EMPLOYEE TO TAPE  
2610 FOR  JI=0 TO 15:WRITE #-1,A(I,JI):NEXT :FOR  JI=1 TO 5:WRITE #-1,A$(I,JI):NEXT  JI  
2620 RETURN   
2650 REM OUTPUT 1 EMPLOYEE TO DISKETTE  
2660 FOR  JI=0 TO 15:WRITE # 1,A(I,JI):NEXT :FOR  JI=1 TO 5:WRITE # 1,A$(I,JI):NEXT  JI  
2670 RETURN   
3100 REM EDIT EMPLOYEE  
3110 CLS  
3120 PRINT "EMPLOYEE NUMBER TO EDIT MUST BE LESS THAN";NC+1  
3130 PRINT :INPUT "EMPLOYEE NUMBER TO EDIT(0 TO END)";I  
3135 IF  I=0  THEN  RETURN   
3137  CLS  
3140 A(I,0)=I:GOSUB  6100:PRINT :PRINT   
3150 GOSUB  6000  
3160 PRINT :GOSUB  10100:GOTO  3110  
4800 REM  
5000 REM REPORT GENERATOR  
5005 CLS:INPUT "IS A LINE PRINTER TO BE USED(Y/N)";Z2$:IF  Z2$<>"Y"  AND  Z2$<>"N" THEN GOSUB  10000:GOTO  5005  
5007 CLS:PRINT  TAB(10);"REPORT MENU":PRINT   
5010 PRINT "1. PAYROLL REGISTER  
5020 PRINT "2. COMPLETE EMPLOYEE LIST WITH COMPANY YTD,MTD TOTALS  
5030 PRINT "3. END REPORT GENERATOR  
5060 PRINT :INPUT "ENTER APPROPRIATE CHOICE";Z9  
5065 IF  Z9=3  THEN  RETURN   
5070 ON  Z9 GOSUB  5100,5200,5300  
5080 GOTO  5007  
5100 REM PAYROLL REGISTER  
5103 CLS:INPUT "ENTER DATE FOR THIS PAYROLL REGISTER ";D$  
5105 FOR  I=0  TO  7:V(I)=0:NEXT   
5106 CLS  
5107 F$="PAYROLL REGISTER       "+D$:PRINT  TAB(15); F$:PRINT :IF  Z2$="Y"  THEN  LPRINT  TAB(20); F$:LPRINT " "  
5110 PRINT  F$(4):IF  Z2$="Y"  THEN  LPRINT  F$(4):LPRINT " "  
5115 FOR  I=1  TO  NC  
5117 IF  A$(I,1)="9999"  OR  A$(I,5)<>D$  THEN  GOTO  5133  
5120 PRINT USING  F$(5);"    ",I,A(I,12),A(I,13),A(I,14),A(I,15),A(I,12)-A(I,13)-A(I,14)-A(I,15)  
5122 IF  Z2$="Y"  THEN  LPRINT  USING  F$(5);"    ",I,A(I,12),A(I,13),A(I,14),A(I,15),A(I,12)-A(I,13)-A(I,14)-A(I,15)  
5125 FOR  J=1 TO 4:V(J)=V(J)+A(I,J+11):NEXT   
5130 IF  I/12=INT(I/12)  AND  Z2$="N"  THEN  PRINT :GOSUB  10100  
5133 NEXT  I  
5135 PRINT :IF  Z2$="Y"  THEN  LPRINT " "  
5137 NET=V(1)-V(2)-V(3)-V(4)  
5140 PRINT USING  F$(8);"TOTALS",V(1),V(2),V(3),V(4),NET  
5150 IF  Z2$="Y"  THEN  LPRINT  USING  F$(8);"TOTALS",V(1),V(2),V(3),V(4),NET  
5190 PRINT :GOSUB  10100  
5195 RETURN   
5200 REM COMPLETE EMPLOYEE LIST  
5203 FOR  I=1 TO 11:V(I)=0:NEXT   
5205 F$="EMPLOYEE LIST":PRINT  TAB(20); F$:IF  Z2$="Y"  THEN  LPRINT  TAB(20); F$:LPRINT " "  
5210 CLS  
5215 FOR  I=1  TO  NC  
5220 IF  A$(I,1)="9999"  THEN  GOTO  5255  
5230 GOSUB  6100:IF  Z2$="Y"  THEN  LPRINT " ":LPRINT " ":GOSUB  6200  
5240 FOR  J=4  TO  11:V(J)=V(J)+A(I,J):NEXT   
5250 IF  Z2$<>"Y"  THEN  PRINT :GOSUB  10100:CLS:PRINT   
5252 PRINT   
5255 NEXT  I  
5257 IF  Z2$="Y"  THEN  LPRINT " ":LPRINT " "  
5260 PRINT :INPUT "PRESS ENTER FOR COMPANY TOTALS";Z9$  
5265 CLS:PRINT  TAB(20); "COMPANY TOTALS":IF  Z2$="Y"  THEN  LPRINT  TAB(20);"COMPANY TOTALS":LPRINT " ":LPRINT " "  
5270 PRINT  F$(7):PRINT :IF  Z2$="Y"  THEN  LPRINT  F$(7):LPRINT " "  
5275 V(1)=V(4)-V(5)-V(6)-V(7):V(2)=V(8)-V(9)-V(10)-V(11)  
5280 PRINT USING  F$(8);"YTD",V(4),V(5),V(6),V(7),V(1)  
5282 PRINT USING  F$(8);"MTD",V(8),V(9),V(10),V(11),V(2)  
5284 IF  Z2$<>"Y"  THEN  GOTO  5289  
5285 LPRINT  USING  F$(8);"YTD",V(4),V(5),V(6),V(7),V(1)  
5286 LPRINT  USING  F$(8);"MTD",V(8),V(9),V(10),V(11),V(2)  
5289 PRINT :GOSUB  10100  
5290 RETURN   
5300 RETURN   
5400 REM  
6000 REM SBR FOR INPUTTING DATA ON 1 EMPLOYEE  
6005 F$(9)="%                % "  
6006 F$(10)="     #####.##      "  
6010 A(I,0)=I  
6013 PRINT  "EMPLOYEE # ";I  
6015 PRINT USING  F$(9);A$(I,1),:INPUT "EMPL. NAME    ";A$(I,1)  
6018 PRINT USING  F$(9);A$(I,2),:INPUT "SS#           ";A$(I,2)  
6020 PRINT USING  F$(9);A$(I,3),:INPUT "ADDR LINE1    ";A$(I,3)  
6022 PRINT USING  F$(9);A$(I,4),:INPUT "ADDR LINE2    ";A$(I,4)  
6024 PRINT USING  F$(9);A$(I,5),:INPUT "LASTPAYDAY    ";A$(I,5)  
6026 PRINT USING  F$(10);A(I,1),:INPUT "PAY RATE      ";A(I,1)  
6028 PRINT USING  F$(10);A(I,2),:INPUT "# EXEMPTION   ";A(I,2)  
6030 PRINT USING  F$(10);A(I,3),:INPUT "MAR=2,SING=1  ";A(I,3)  
6035 IF  A(I,3)<>1  AND  A(I,3)<>2  THEN  GOSUB  10000:GOTO  6030  
6040 PRINT  F$(4):PRINT USING  F$(5);"YTD",I,A(I,4),A(I,5),A(I,6),A(I,7)  
6045 INPUT "YTD GROSS,FED WITH,FICA,SPECIAL";A(I,4),A(I,5),A(I,6),A(I,7)  
6050 PRINT  F$(4):PRINT USING  F$(5);"MTD",I,A(I,8),A(I,9),A(I,10),A(I,11)  
6055 INPUT "MTD GROSS,FED WITH,FICA,SPECIAL";A(I,8),A(I,9),A(I,10),A(I,11)  
6062 PRINT  F$(4):PRINT USING  F$(5);"CURR",I,A(I,12),A(I,13),A(I,14),A(I,15)  
6065 INPUT "CURR GROSS,FED WITH,FICA,SPECIAL";A(I,12),A(I,13),A(I,14),A(I,15)  
6090 RETURN   
6100 REM PRINT EMPLOYEE RECORD ON CRT  
6105 PRINT  "EMPLOYEE # ";I  
6110 PRINT USING  F$(1);A$(I,1),A$(I,2),A(I,1)  
6120 PRINT USING  F$(2);A$(I,3),A$(I,4)  
6125 PRINT USING  F$(3);A$(I,5),A(I,2),A(I,3)  
6130 PRINT :PRINT  F$(4)  
6135 PRINT USING  F$(5);"YTD",I,A(I,4),A(I,5),A(I,6),A(I,7),A(I,4)-A(I,5)-A(I,6)-A(I,7)  
6140 PRINT USING  F$(5);"MTD",I,A(I,8),A(I,9),A(I,10),A(I,11),A(I,8)-A(I,9)-A(I,10)-A(I,11)  
6150 PRINT USING  F$(5);"CURR",I,A(I,12),A(I,13),A(I,14),A(I,15),A(I,12)-A(I,13)-A(I,14)-A(I,15)  
6170 RETURN   
6200 REM PRINT 1 EMPLOYEE RECORD ON PRINTER  
6210 LPRINT  USING  F$(1);A$(I,1),A$(I,2),A(I,1)  
6220 LPRINT  USING  F$(2);A$(I,3),A$(I,4)  
6225 LPRINT  USING  F$(3);A$(I,5),A(I,2),A(I,3)  
6230 LPRINT " ":LPRINT  F$(4)  
6235 LPRINT  USING  F$(5);"YTD",I,A(I,4),A(I,5),A(I,6),A(I,7),A(I,4)-A(I,5)-A(I,6)-A(I,7)  
6240 LPRINT  USING  F$(5);"MTD",I,A(I,8),A(I,9),A(I,10),A(I,11),A(I,8)-A(I,9)-A(I,10)-A(I,11)  
6250 LPRINT  USING  F$(5);"CURR",I,A(I,12),A(I,13),A(I,14),A(I,15),A(I,12)-A(I,13)-A(I,14)-A(I,15)  
6270 RETURN   
6300 REM  
7000 REM POST TO ACCTS.  
7010 CLS  
7020 INPUT "POSTING ACCTS-PRESS Y TO PROCEED,N TO RETURN";Z9$  
7030 IF  Z9$="N"  THEN  RETURN   
7040 IF  Z9$<>"Y"  THEN  GOSUB  10000:PRINT :GOTO  7020  
7050 PRINT :INPUT "DATE OF PAYROLL ";D$  
7060 PRINT :GOSUB  10100  
7070 CLS:PRINT :PRINT :PRINT :PRINT  TAB(20);"COMPUTING"  
7080 FOR  I=1 TO NC  
7090 IF  D$<>A$(I,5)  THEN  GOTO  7150  
7100 X=A(I,12):A(I,4)=A(I,4)+X:A(I,8)=A(I,8)+X  
7105 X=A(I,13):A(I,5)=A(I,5)+X:A(I,9)=A(I,9)+X  
7110 X=A(I,14):A(I,6)=A(I,6)+X:A(I,10)=A(I,10)+X  
7115 X=A(I,15):A(I,7)=A(I,7)+X:A(I,11)=A(I,11)+X  
7130 A$(I,5)=LEFT$(A$(I,5),5)  
7150 NEXT  I  
7160 PRINT :PRINT "ALL DONE":GOSUB  10100:RETURN   
7300 CLS:PRINT "END OF PERIOD FILE MAINTENANCE":PRINT   
7310 INPUT "DO YOU WANT TO ZERO ALL MTD AMOUNTS(Y/N)";Z9$  
7320 IF  Z9$<>"Y"  AND  Z9$<>"N"  THEN  GOSUB  10000:GOTO  7310  
7330 IF  Z9$="Y"  THEN  FOR  I=1 TO NC:A(I,8)=0:A(I,9)=0:A(I,10)=0:A(I,11)=0:NEXT   
7340 PRINT   
7350 INPUT "DO YOU WANT TO ZERO ALL YTD AMOUNTS(Y/N)";Z9$  
7360 IF  Z9$<>"Y"  AND  Z9$<>"N"  THEN  GOSUB  10000:GOTO  7350  
7370 IF  Z9$=Y" THEN FOR I=1TONC:A(I,4)=0:A(I,5)=0:A(I,6)=0:A(I,7)=0:NEXT  
7390 RETURN   
7800 REM SUBROUTINE FOR INPUTTING DATA & COMPUTING PAYROLL  
7801 CLS:GOSUB  8000:GOSUB  10100:CLS  
7802 INPUT "ENTER PAY DATE(MM/DD/YY)";D$  
7803 IF  LEN(D$)<>8  THEN  PRINT "INPUT ERROR":PRINT :GOTO  7802  
7805 PRINT "ENTER ID#(0 TO END),REG HRS,PREM HRS":INPUT  I,H1,H2  
7810 IF  I=0  THEN  RETURN   
7813 IF  I<0  OR  I>NC  OR  I<>INT(I)  OR  A$(I,1)="9999"  THEN  GOTO  7840:GOTO  7805  
7815 M=A(I,3):N=A(I,2):R1=A(I,1)  
7820 GOSUB  8200:GOSUB  8215:GOSUB  8300  
7822 T7=0:INPUT "ENTER SPECIAL WITHHOLDING(JUST ENTER IF NONE)";T7  
7825 GOSUB 8400:REM COMPUTE FICA:STORE DATA IN EMPLOYEE RECORD  
7830 PRINT :GOSUB  6100:PRINT :GOSUB  10100  
7835 CLS:GOTO  7805  
7840 PRINT  "INPUT ERROR. TRY AGAIN.":PRINT :GOTO  7805  
8000 REM SUBROUTINE GIVING INSTRUCTIONS  
8010 PRINT "THE FOLLOWING COMPUTES FEDERAL AND FICA WITHHOLDING";  
8015 PRINT  "AMOUNTS."  
8020 PRINT  "INPUT FOR EACH EMPLOYEE IS AN ID#(1-25)"  
8030 PRINT  "THEN NUMBER OF REGULAR HOURS (I.E. AT NORMAL RATE)"  
8040 PRINT  "THEN NUMBER OF PREMIUM HOURS (I.E. AT O.T. RATE)"  
8050 PRINT  "THEN PRESS ENTER KEY."  
8060 PRINT "NEXT INPUT ANY SPECIAL WITHHOLDING AMT. & PRESS ENTER"  
8080 PRINT  "NOW REPEAT STARTING WITH ID# FOR NEXT EMPLOYEE,ETC"  
8090 PRINT "BE SURE TO PUT A COMMA(,) BETWEEN EACH ENTRY FOR";  
8091 PRINT  "EACH EMPLOYEE."  
8095 PRINT  "INPUT 0 FOR END OF DATA AND ENTER WHEN REQUESTED."  
8096 PRINT  "PRINT OUT OF ALL RESULTS WILL FOLLOW."  
8100 INPUT  "PRESS ANY DIGIT AND THEN PRESS ENTER TO BEGIN.";Z7  
8110 RETURN   
8200 REM SUBROUTINE FOR COMPUTING GROSS PAY  
8205 G=H1*R1 + 1.5*H2*R1  
8210 RETURN   
8215 REM SUBROUTINE COMPUTES FEDERAL WAGES  
8220 W = G - 14.40*N  
8225 RETURN   
8300 REM SUBROUTINE COMPUTING WITHHOLDING  
8305 REM T1 IS WITHHOLDING. X IS BRACKET WE ARE IN.  
8310 T1=0 : X=2  
8315 IF  W<= 0 THEN GOTO  8345  
8320 IF  W<= P(M,X) THEN GOTO  8340  
8325 T1=T1 + INT((P(M,X)-P(M,X-1))*B(M,X-1)*100+.5)/100  
8330 X=X+1  
8335 GOTO  8320  
8340 T1=T1 + INT((W - P(M,X-1))*B(M,X-1)*100+.5)/100  
8345 RETURN   
8400 REM SETS UP PAY ARRAY  
8410 A(I,12)=G:A(I,13)=T1:A(I,15)=T7:A(I,14)=FW*G  
8420 FOR  K=12 TO 15:X=A(I,K):GOSUB  11100:A(I,K)=X:NEXT   
8430 A$(I,5)=D$  
8440 RETURN   
9000 REM FORMATTING VARIABLES  
9010 F$(1)="NAME %                      %  SS NO. %          %  RATE ###.##"  
9020 F$(2)="ADDR %                      %   %                   %"  
9030 F$(3)="LAST PAY %        %   EXEMPT ##     MAR(2)-SING(1) #"  
9040 F$(4)="     ID     GROSS      FED WITH.     FICA    SPECIAL     NET"  
9050 F$(5)="%  % ##   ######.##   ######.##    #####.##  #####.## ######.##"  
9060 F$(6)=" %                 %  ######.##   ######.## ######.## ######.##"  
9070 F$(7)="            GROSS      FED WITH.     FICA    SPECIAL     NET"  
9080 F$(8)="%     %   ######.##   ######.##    #####.##  #####.## ######.##"  
9099 RETURN   
10000 REM INPUT ERROR SBR  
10010 PRINT "INPUT ERROR! TRY AGAIN!":FOR  Z9=1 TO 300:NEXT  Z9  
10020 RETURN   
10100 INPUT "PRESS ENTER TO CONTINUE";Z9:RETURN   
10200 REM Y,N,A SBR  
10205 Z9$=" "  
10210 INPUT "ENTER Y IF OK,N IF ERROR,A TO ABORT";Z9$  
10220 IF  Z9$<>"Y"  AND  Z9$<>"N"  AND  Z9$<>"A" THEN GOSUB  10000:GOTO 10205  
10230 RETURN   
10300 REM Y,N SBR  
10305 Z9$=" "  
10310 INPUT "ENTER Y IF OK, N IF ERROR";Z9$  
10320 IF  Z9$<>"Y"  AND  Z9$<>"N" THEN GOSUB  10000:GOTO  10305  
10330 RETURN   
10400 REM MORE ENTRY? SBR  
10405 Z9$=" "  
10410 INPUT "DO YOU DESIRE MORE ENTRIES(Y/N)";Z9$  
10420 IF  Z9$<>"Y"  AND  Z9$<>"N" THEN GOSUB  10000:GOTO  10405  
10430 RETURN   
10500 REM ONLY Y/N SBR  
10510 IF  Z9$<>"Y"  AND  Z9$<>"N" THEN GOSUB  10000  
10520 RETURN   
11000 REM ELIMINATES TRAILING BLANKS OF VARIABLE Z8$  
11010 IF  RIGHT$(Z8$,1)=" "  THEN  Z8$=LEFT$(Z8$,LEN(Z8$)-1):GOTO  11010  
11020 RETURN   
11100 X=INT(100*X+.5)/100:RETURN   
14000 REM P(1, ) GIVES WAGE BRACKET BDYS. FOR SINGLE EARNERS.  
14010 REM P(2, ) GIVES WAGE BRACKET BDYS. FOR MARRIED EARNERS.  
14020 REM B(1, ) GIVES WAGE WITHHOLDING % FOR SINGLE EARNERS.  
14030 REM B(2, ) GIVES WAGE WITHHOLDING % FOR MARRIED EARNERS.  
14035 FW=.0613:REM FICA WITHOLDING DECIMAL  
14040 REM NEXT LINE GIVES P(1, )  
14050 DATA  0,27,63,131,196,273,331,433,100000  
14060 REM NEXT LINE GIVES P(2, )  
14070 DATA  0,46,127,210,288,369,454,556,100000  
14080 REM NEXT LINE GIVES B(1, )  
14090 DATA  0,.15,.18,.21,.26,.30,.34,.39  
14100 REM NEXT LINE GIVES B(2, )  
14110 DATA  0,.15,.18,.21,.24,.28,.32,.37  
14120 REM NOW LOAD P() AND B() ARRAYS  
14130 FOR  I=1  TO  2:FOR  J=1  TO  9:READ  P(I,J):NEXT  J:NEXT  I  
14140 FOR  I=1  TO  2:FOR  J=1  TO  8:READ  B(I,J):NEXT  J:NEXT  I  
14150 RETURN   
15000 RESUME 500  

